/*
 * Decompiled with CFR 0.152.
 */
package net.yggdraszil.edexpandere.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.yggdraszil.edexpandere.datagen.ModAdvancementProvider;
import net.yggdraszil.edexpandere.datagen.ModBlockTagGenerator;
import net.yggdraszil.edexpandere.datagen.ModEngLangProvider;
import net.yggdraszil.edexpandere.datagen.ModGlobalLootModifiersProvider;
import net.yggdraszil.edexpandere.datagen.ModItemModelProvider;
import net.yggdraszil.edexpandere.datagen.ModItemTagGenerator;
import net.yggdraszil.edexpandere.datagen.ModLootTableProvider;

public class DataGenerators {

    @Mod.EventBusSubscriber(modid="edexpandere", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModRecipeProvider {
        @SubscribeEvent
        public static void gatherData(GatherDataEvent event) {
            DataGenerator generator = event.getGenerator();
            PackOutput output = generator.getPackOutput();
            ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
            CompletableFuture lookupProvider = event.getLookupProvider();
            boolean includeClient = event.includeClient();
            boolean includeServer = event.includeServer();
            if (includeClient) {
                generator.addProvider(includeClient, (DataProvider)new ModEngLangProvider(output));
                generator.addProvider(includeClient, (DataProvider)new ModItemModelProvider(output, existingFileHelper));
            }
            if (includeServer) {
                generator.addProvider(includeServer, (DataProvider)new net.yggdraszil.edexpandere.datagen.recipes.ModRecipeProvider(output));
                generator.addProvider(includeServer, (DataProvider)ModLootTableProvider.create(output));
                ModBlockTagGenerator blockTagGenerator = (ModBlockTagGenerator)generator.addProvider(includeServer, (DataProvider)new ModBlockTagGenerator(output, lookupProvider, existingFileHelper));
                generator.addProvider(includeServer, (DataProvider)new ModItemTagGenerator(output, lookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
                generator.addProvider(includeServer, (DataProvider)new ModGlobalLootModifiersProvider(output));
                generator.addProvider(includeServer, (DataProvider)new ModAdvancementProvider(output, lookupProvider, existingFileHelper));
            }
        }
    }
}

